#include <bits/stdc++.h>
using namespace std;
typedef long long ull;
struct tac
{
    ull x, y;
};

tac p0;

tac drugi(stack<tac> &s)
{
    tac p = s.top();
    s.pop();
    tac res = s.top();
    s.push(p);
    return res;
}

void swap(tac &p1, tac &p2)
{
    tac temp = p1;
    p1 = p2;
    p2 = temp;
}

ull distSq(tac p1, tac p2)
{
    ull px =(p1.x - p2.x), py=p1.y-p2.y;
    return px*px + py*py;
}

int zaokret(tac p, tac q, tac r)
{
    int val = (q.y - p.y) * (r.x - q.x) -
              (q.x - p.x) * (r.y - q.y);

    if (val == 0) return 0;
    return (val > 0)? 1: 2;
}

int compare(const void *vp1, const void *vp2)
{
   tac *p1 = (tac *)vp1;
   tac *p2 = (tac *)vp2;

   int o = zaokret(p0, *p1, *p2);
   if (o == 0)
     return (distSq(p0, *p2) >= distSq(p0, *p1))? -1 : 1;

   return (o == 2)? -1: 1;
}

stack<tac> convexHull(tac points[], int n)
{
   ull ymin = points[0].y, min = 0;
   for (int i = 1; i < n; i++)
   {
     ull y = points[i].y;

     if ((y < ymin) || (ymin == y &&
         points[i].x < points[min].x))
        ymin = points[i].y, min = i;
   }

   swap(points[0], points[min]);

   p0 = points[0];
   qsort(&points[1], n-1, sizeof(tac), compare);

   int m = 1;
   for (int i=1; i<n; i++)
   {
       while (i < n-1 && zaokret(p0, points[i],
                                    points[i+1]) == 0)
          i++;


       points[m] = points[i];
       m++;
   }

   stack<tac> s;
   s.push(points[0]);
   s.push(points[1]);
   s.push(points[2]);

   for (int i = 3; i < m; i++)
   {
      while (s.size()>1 && zaokret(drugi(s), s.top(), points[i]) != 2)
         s.pop();
      s.push(points[i]);
   }

    return s;
}

ull heron(tac a, tac b, tac c){
    ull u = (b.y-c.y)*a.x,
        v = b.x*(c.y-a.y),
        w = c.x*(a.y-b.y);
    return abs(u+v+w)/2;
}

ull povrsina(stack<tac> s){
    ull p=0;
    while(!s.empty()){
        tac a = s.top(); s.pop();
        tac b =s.top(); s.pop();
        if(s.empty())return p;
        p+=heron(a,b,s.top());
        s.push(a);
    }
    return p;
}

ull konacno(stack<tac>s){
    ull pmax=0;
    tac a1=s.top(); s.pop(); tac a2 = s.top(); s.pop();
    tac ppr=a1, pr=a2;
    while(!s.empty()){
        pmax=max(pmax,heron(a1,a2,s.top()));
        ppr=pr; pr=s.top(); s.pop();
    }
    pmax=max(pmax,heron(ppr,pr,a1));
    pmax=max(pmax,heron(pr,a1,a2));
    return pmax;
}

int main()
{
    int n; cin >> n;
    tac points[n];
    for(int i=0; i<n; i++){
        cin >> points[i].x >> points[i].y;
    }
    stack<tac> s = convexHull(points, n);
    cout << povrsina(s) -konacno(s);
    return 0;
}